<?php

// BUTTONS - shape

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_button', 'style' );
	bt_bb_remove_params( 'bt_bb_button', 'shape' );
}
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_button', array(		
		array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Style', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__( 'Outline', 'bold-builder' ) => 'outline',
				esc_html__( 'Filled', 'bold-builder' ) => 'filled',
				esc_html__( 'Clean', 'bold-builder' ) => 'clean',
				esc_html__( 'Lined', 'bold-builder' ) => 'lined'
			)
		),
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('Inherit', 'avantage' ) => 'inherit',
				esc_html__('Square', 'avantage' ) => 'square',
				esc_html__('Rounded', 'avantage' ) => 'rounded',
				esc_html__('Round', 'avantage' ) => 'round',
				esc_html__('Slanted Right', 'avantage' ) => 'slanted_right',
				esc_html__('Slanted Left', 'avantage' ) => 'slanted_left',
				esc_html__( 'Lined', 'avantage' ) => 'lined'
			)
		),
	));
}


// CONTENT SLIDER - new: dots_style, arrows_style, arrows_position
// edited: show_dots, gap

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_content_slider', 'arrows_size' );
	bt_bb_remove_params( 'bt_bb_content_slider', 'show_dots' );
	bt_bb_remove_params( 'bt_bb_content_slider', 'gap' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_content_slider', array(
		array( 'param_name' => 'arrows_size', 'type' => 'dropdown', 'preview' => true, 'default' => 'normal', 'heading' => esc_html__( 'Navigation arrows size', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('No arrows', 'avantage' ) => 'no_arrows',
				esc_html__('Small', 'avantage' ) => 'small',
				esc_html__('Normal', 'avantage' ) => 'normal',
				esc_html__('Large', 'avantage' ) => 'large'
			)
		),
		array( 'param_name' => 'arrows_style', 'type' => 'dropdown', 'preview' => true, 'default' => 'normal', 'heading' => esc_html__( 'Navigation arrows style', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('Default', 'avantage' ) => '',
				esc_html__('Transparent background, light arrow', 'avantage' ) => 'transparent_light',
				esc_html__('Transparent background, dark arrow', 'avantage' ) => 'transparent_dark',
				esc_html__('Accent background, light arrow', 'avantage' ) => 'accent_light',
				esc_html__('Accent background, dark arrow', 'avantage' ) => 'accent_dark',
				esc_html__('Alternate background, light arrow', 'avantage' ) => 'alternate_light',
				esc_html__('Alternate background, dark arrow', 'avantage' ) => 'alternate_dark'
			)
		),
		array( 'param_name' => 'arrows_position', 'type' => 'dropdown', 'preview' => true, 'default' => 'normal', 'heading' => esc_html__( 'Navigation arrows position', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('At sides', 'avantage' ) => '',
				esc_html__('From outside, at sides', 'avantage' ) => 'outside',
				esc_html__('Bottom left', 'avantage' ) => 'bottom_left',
				esc_html__('Bottom right', 'avantage' ) => 'bottom_right',
				esc_html__('Below', 'avantage' ) => 'below',
				esc_html__('Below left', 'avantage' ) => 'below_left',
				esc_html__('Below right', 'avantage' ) => 'below_right'
			)
		),
		array( 'param_name' => 'show_dots', 'type' => 'dropdown', 'heading' => esc_html__( 'Dots navigation', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('Bottom', 'avantage' ) => 'bottom',
				esc_html__('Below slider', 'avantage' ) => 'below',
				esc_html__('Left', 'avantage' ) => 'left',
				esc_html__('Right', 'avantage' ) => 'right',
				esc_html__('Hide', 'avantage' ) => 'hide'
			)
		),
		array( 'param_name' => 'dots_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Dots style', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('Inherit', 'avantage' ) => '',
				esc_html__('Accent active dot', 'avantage' ) => 'accent_dot',
				esc_html__('Alternate active dot', 'avantage' ) => 'alternate_dot',
				esc_html__('Light active dot', 'avantage' ) => 'light_dot',
				esc_html__('Dark active dot', 'avantage' ) => 'dark_dot'
			)
		),
		array( 'param_name' => 'gap', 'type' => 'dropdown', 'heading' => esc_html__( 'Gap', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('No gap', 'avantage' ) => 'no_gap',
				esc_html__('Small', 'avantage' ) => 'small',
				esc_html__('Normal', 'avantage' ) => 'normal',
				esc_html__('Large', 'avantage' ) => 'large',
				esc_html__('Extra Large', 'avantage' ) => 'extra_large',
				esc_html__('Huge', 'avantage' ) => 'huge'
			)
		),
	));
}

function avantage_bt_bb_content_slider_class( $class, $atts ) {
	if ( isset( $atts['dots_style'] ) && $atts['dots_style'] != '' ) {
		$class[] = 'bt_bb_dots_style_' . $atts['dots_style'];
	}
	if ( isset( $atts['arrows_style'] ) && $atts['arrows_style'] != '' ) {
		$class[] = 'bt_bb_arrows_style' . '_' . $atts['arrows_style'];
	}
	if ( isset( $atts['arrows_position'] ) && $atts['arrows_position'] != '' ) {
		$class[] = 'bt_bb_arrows_position' . '_' . $atts['arrows_position'];
	}
	return $class;
}
add_filter( 'bt_bb_content_slider_class', 'avantage_bt_bb_content_slider_class', 10, 2 );

// HEADLINE - font_weight, semitransparent_text

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_headline', 'font_weight' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_headline', array(
		array( 'param_name' => 'font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'bold-builder' ), 'group' => esc_html__( 'Font', 'bold-builder' ),
			'value' => array(
				esc_html__( 'Default', 'bold-builder' ) => '',
				esc_html__( 'Normal', 'bold-builder' ) => 'normal',
				esc_html__( 'Bold', 'bold-builder' ) => 'bold',
				esc_html__( 'Bolder', 'bold-builder' ) => 'bolder',
				esc_html__( 'Lighter', 'bold-builder' ) => 'lighter',
				esc_html__( 'Light', 'bold-builder' ) => 'light',
				esc_html__( 'Thin', 'bold-builder' ) => 'thin',
				esc_html__( 'Font weight 100', 'bold-builder' ) => '100',
				esc_html__( 'Font weight 200', 'bold-builder' ) => '200',
				esc_html__( 'Font weight 300', 'bold-builder' ) => '300',
				esc_html__( 'Font weight 400', 'bold-builder' ) => '400',
				esc_html__( 'Font weight 500', 'bold-builder' ) => '500',
				esc_html__( 'Font weight 600', 'bold-builder' ) => '600',
				esc_html__( 'Font weight 700', 'bold-builder' ) => '700',
				esc_html__( 'Font weight 800', 'bold-builder' ) => '800',
				esc_html__( 'Font weight 900', 'bold-builder' ) => '900',
			)
		),
		array( 'param_name' => 'semitransparent_text', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'avantage' ) => 'true' ), 'heading' => esc_html__( 'Semitransparent text', 'avantage' ), 'preview' => true, 'group' => esc_html__( 'Design', 'avantage' ),
		),
	));
}

function avantage_bt_bb_headline_class( $class, $atts ) {
	if ( isset( $atts['semitransparent_text'] ) && $atts['semitransparent_text'] != '' ) {
		$class[] = ' bt_bb_semitransparent_subheadline';
	}
	
	return $class;
}
add_filter( 'bt_bb_headline_class', 'avantage_bt_bb_headline_class', 10, 2 );

// IMAGE - new: fill_background_color

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_image', array(		
		array( 'param_name' => 'fill_background_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Fill background color', 'avantage' ),'group' => esc_html__( 'Content', 'avantage' ) ,
			'value' => array(
				esc_html__( 'Full', 'avantage' ) => 'full',
				esc_html__( 'Match content height', 'avantage' ) => 'match_content_height'
			)
		),
	));
}

function avantage_bt_bb_image_class( $class, $atts ) {
	if ( isset( $atts['fill_background_color'] ) && $atts['fill_background_color'] != '' ) {
		$class[] = 'bt_bb_fill_background_color' . '_' . $atts['fill_background_color'];
	}
	
	return $class;
}
add_filter( 'bt_bb_image_class', 'avantage_bt_bb_image_class', 10, 2 );

// IMAGE SLIDER - new: dots_style, arrows_size, arrows_style, arrows_position; 
// deleted: size, pause_on_hover, use_lightbox; changed: show_dots

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_slider', 'size' );
	bt_bb_remove_params( 'bt_bb_slider', 'pause_on_hover' );
	bt_bb_remove_params( 'bt_bb_slider', 'use_lightbox' );
	bt_bb_remove_params( 'bt_bb_slider', 'show_dots' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_slider', array(
		array( 'param_name' => 'show_dots', 'type' => 'dropdown', 'heading' => esc_html__( 'Dots navigation', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('Bottom', 'avantage' ) => 'bottom',
				esc_html__('Below', 'avantage' ) => 'below',
				esc_html__('Left', 'avantage' ) => 'left',
				esc_html__('Right', 'avantage' ) => 'right',
				esc_html__('Hide', 'avantage' ) => 'hide'
			)
		),
		array( 'param_name' => 'dots_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Dots style', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('Inherit', 'avantage' ) => '',
				esc_html__('Accent active dot', 'avantage' ) => 'accent_dot',
				esc_html__('Alternate active dot', 'avantage' ) => 'alternate_dot',
				esc_html__('Light active dot', 'avantage' ) => 'light_dot',
				esc_html__('Dark active dot', 'avantage' ) => 'dark_dot'
			)
		),		
		array( 'param_name' => 'arrows_size', 'type' => 'dropdown', 'preview' => true, 'default' => 'normal', 'heading' => esc_html__( 'Navigation arrows size', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('Small', 'avantage' ) => 'small',
				esc_html__('Normal', 'avantage' ) => 'normal',
				esc_html__('Large', 'avantage' ) => 'large'
			)
		),
		array( 'param_name' => 'arrows_style', 'type' => 'dropdown', 'preview' => true, 'default' => 'normal', 'heading' => esc_html__( 'Navigation arrows style', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('Default', 'avantage' ) => '',
				esc_html__('Transparent background, light arrow', 'avantage' ) => 'transparent_light',
				esc_html__('Transparent background, dark arrow', 'avantage' ) => 'transparent_dark',
				esc_html__('Accent background, light arrow', 'avantage' ) => 'accent_light',
				esc_html__('Accent background, dark arrow', 'avantage' ) => 'accent_dark',
				esc_html__('Alternate background, light arrow', 'avantage' ) => 'alternate_light',
				esc_html__('Alternate background, dark arrow', 'avantage' ) => 'alternate_dark'
			)
		),
		array( 'param_name' => 'arrows_position', 'type' => 'dropdown', 'preview' => true, 'default' => 'normal', 'heading' => esc_html__( 'Navigation arrows position', 'avantage' ), 'group' => esc_html__( 'Design', 'avantage' ),
			'value' => array(
				esc_html__('At sides', 'avantage' ) => '',
				esc_html__('From outside, at sides', 'avantage' ) => 'outside',
				esc_html__('Bottom left', 'avantage' ) => 'bottom_left',
				esc_html__('Bottom right', 'avantage' ) => 'bottom_right',
				esc_html__('Below', 'avantage' ) => 'below',
				esc_html__('Below left', 'avantage' ) => 'below_left',
				esc_html__('Below right', 'avantage' ) => 'below_right'
			)
		),				
	));
}

function avantage_bt_bb_slider_class( $class, $atts ) {
	if ( isset( $atts['dots_style'] ) && $atts['dots_style'] != '' ) {
		$class[] = 'bt_bb_dots_style_' . $atts['dots_style'];
	}
	if ( isset( $atts['arrows_size'] ) && $atts['arrows_size'] != '' ) {
		$class[] = 'bt_bb_arrows_size' . '_' . $atts['arrows_size'];
	}

	if ( isset( $atts['arrows_style'] ) && $atts['arrows_style'] != '' ) {
		$class[] = 'bt_bb_arrows_style' . '_' . $atts['arrows_style'];
	}

	if ( isset( $atts['arrows_position'] ) && $atts['arrows_position'] != '' ) {
		$class[] = 'bt_bb_arrows_position' . '_' . $atts['arrows_position'];
	}

	return $class;
}
add_filter( 'bt_bb_slider_class', 'avantage_bt_bb_slider_class', 10, 2 );

// CONTENT SLIDER ITEM - new: show_boxed_content

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_content_slider_item', array(	
		array( 'param_name' => 'show_boxed_content', 'type' => 'dropdown', 'default' => 'no', 'heading' => esc_html__( 'Box column content - used to stretch or box column content, only applicable for one and two column layouts, for sliders in wide sections.', 'avantage' ),
			'value' => array(
				esc_html__( 'No', 'avantage' ) => 'no',
				esc_html__( 'Box both columns', 'avantage' ) => 'yes',
				esc_html__( 'Box left column', 'avantage' ) => 'left',
				esc_html__( 'Box right column', 'avantage' ) => 'right'
			)
		)
	));
}

function avantage_bt_bb_content_slider_item_class( $class, $atts ) {
	if ( isset( $atts['show_boxed_content'] ) && $atts['show_boxed_content'] != '' ) {
		if ( $atts['show_boxed_content'] == 'yes' ) {
				$class[] = 'bt_bb_show_boxed_content';
		}
		if ( $atts['show_boxed_content'] == 'left' ) {
				$class[] = 'bt_bb_show_left_boxed_content';
		}
		if ( $atts['show_boxed_content'] == 'right' ) {
				$class[] = 'bt_bb_show_right_boxed_content';
		}

	}
	return $class;
}
add_filter( 'bt_bb_content_slider_item_class', 'avantage_bt_bb_content_slider_item_class', 10, 2 );


